/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;

public class ListHandshakesForAccountPublisher
implements SdkPublisher<ListHandshakesForAccountResponse> {
    private final OrganizationsAsyncClient client;
    private final ListHandshakesForAccountRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHandshakesForAccountPublisher(OrganizationsAsyncClient client, ListHandshakesForAccountRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHandshakesForAccountPublisher(OrganizationsAsyncClient client, ListHandshakesForAccountRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHandshakesForAccountResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHandshakesForAccountResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListHandshakesForAccountPublisher resume(ListHandshakesForAccountResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHandshakesForAccountPublisher(this.client, (ListHandshakesForAccountRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHandshakesForAccountPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListHandshakesForAccountResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListHandshakesForAccountResponseFetcher
    implements AsyncPageFetcher<ListHandshakesForAccountResponse> {
        private ListHandshakesForAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListHandshakesForAccountResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListHandshakesForAccountResponse> nextPage(ListHandshakesForAccountResponse previousPage) {
            if (previousPage == null) {
                return ListHandshakesForAccountPublisher.this.client.listHandshakesForAccount(ListHandshakesForAccountPublisher.this.firstRequest);
            }
            return ListHandshakesForAccountPublisher.this.client.listHandshakesForAccount((ListHandshakesForAccountRequest)((Object)ListHandshakesForAccountPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

