/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;

public class ListCreateAccountStatusIterable
implements SdkIterable<ListCreateAccountStatusResponse> {
    private final OrganizationsClient client;
    private final ListCreateAccountStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCreateAccountStatusIterable(OrganizationsClient client, ListCreateAccountStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCreateAccountStatusResponseFetcher();
    }

    public Iterator<ListCreateAccountStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListCreateAccountStatusIterable resume(ListCreateAccountStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCreateAccountStatusIterable(this.client, (ListCreateAccountStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCreateAccountStatusIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListCreateAccountStatusResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListCreateAccountStatusResponseFetcher
    implements SyncPageFetcher<ListCreateAccountStatusResponse> {
        private ListCreateAccountStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListCreateAccountStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCreateAccountStatusResponse nextPage(ListCreateAccountStatusResponse previousPage) {
            if (previousPage == null) {
                return ListCreateAccountStatusIterable.this.client.listCreateAccountStatus(ListCreateAccountStatusIterable.this.firstRequest);
            }
            return ListCreateAccountStatusIterable.this.client.listCreateAccountStatus((ListCreateAccountStatusRequest)((Object)ListCreateAccountStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

