/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;

public class ListChildrenIterable
implements SdkIterable<ListChildrenResponse> {
    private final OrganizationsClient client;
    private final ListChildrenRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChildrenIterable(OrganizationsClient client, ListChildrenRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChildrenResponseFetcher();
    }

    public Iterator<ListChildrenResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListChildrenIterable resume(ListChildrenResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListChildrenIterable(this.client, (ListChildrenRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListChildrenIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListChildrenResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListChildrenResponseFetcher
    implements SyncPageFetcher<ListChildrenResponse> {
        private ListChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListChildrenResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListChildrenResponse nextPage(ListChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListChildrenIterable.this.client.listChildren(ListChildrenIterable.this.firstRequest);
            }
            return ListChildrenIterable.this.client.listChildren((ListChildrenRequest)((Object)ListChildrenIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

