/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;

public class ListAccountsForParentPublisher
implements SdkPublisher<ListAccountsForParentResponse> {
    private final OrganizationsAsyncClient client;
    private final ListAccountsForParentRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountsForParentPublisher(OrganizationsAsyncClient client, ListAccountsForParentRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountsForParentPublisher(OrganizationsAsyncClient client, ListAccountsForParentRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountsForParentResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountsForParentResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListAccountsForParentPublisher resume(ListAccountsForParentResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAccountsForParentPublisher(this.client, (ListAccountsForParentRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAccountsForParentPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAccountsForParentResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAccountsForParentResponseFetcher
    implements AsyncPageFetcher<ListAccountsForParentResponse> {
        private ListAccountsForParentResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsForParentResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListAccountsForParentResponse> nextPage(ListAccountsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsForParentPublisher.this.client.listAccountsForParent(ListAccountsForParentPublisher.this.firstRequest);
            }
            return ListAccountsForParentPublisher.this.client.listAccountsForParent((ListAccountsForParentRequest)((Object)ListAccountsForParentPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

