/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;

public final class ListHandshakesForAccountPaginator
implements SdkIterable<ListHandshakesForAccountResponse> {
    private final OrganizationsClient client;
    private final ListHandshakesForAccountRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListHandshakesForAccountPaginator(OrganizationsClient client, ListHandshakesForAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHandshakesForAccountResponseFetcher();
    }

    public Iterator<ListHandshakesForAccountResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListHandshakesForAccountResponseFetcher
    implements NextPageFetcher<ListHandshakesForAccountResponse> {
        private ListHandshakesForAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListHandshakesForAccountResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListHandshakesForAccountResponse nextPage(ListHandshakesForAccountResponse previousPage) {
            if (previousPage == null) {
                return ListHandshakesForAccountPaginator.this.client.listHandshakesForAccount(ListHandshakesForAccountPaginator.this.firstRequest);
            }
            return ListHandshakesForAccountPaginator.this.client.listHandshakesForAccount((ListHandshakesForAccountRequest)((Object)ListHandshakesForAccountPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

