/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;

public final class ListAccountsPaginator
implements SdkIterable<ListAccountsResponse> {
    private final OrganizationsClient client;
    private final ListAccountsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAccountsPaginator(OrganizationsClient client, ListAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountsResponseFetcher();
    }

    public Iterator<ListAccountsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListAccountsResponseFetcher
    implements NextPageFetcher<ListAccountsResponse> {
        private ListAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListAccountsResponse nextPage(ListAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsPaginator.this.client.listAccounts(ListAccountsPaginator.this.firstRequest);
            }
            return ListAccountsPaginator.this.client.listAccounts((ListAccountsRequest)((Object)ListAccountsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

