/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.services.organizations.model.Parent;
import software.amazon.awssdk.services.organizations.model.ParentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListParentsResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListParentsResponse> {
    private final List<Parent> parents;
    private final String nextToken;

    private ListParentsResponse(BuilderImpl builder) {
        super(builder);
        this.parents = builder.parents;
        this.nextToken = builder.nextToken;
    }

    public List<Parent> parents() {
        return this.parents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParentsResponse)) {
            return false;
        }
        ListParentsResponse other = (ListParentsResponse)((Object)obj);
        return Objects.equals(this.parents(), other.parents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListParentsResponse").add("Parents", this.parents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parents": {
                return Optional.of(clazz.cast(this.parents()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<Parent> parents;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParentsResponse model) {
            this.parents(model.parents);
            this.nextToken(model.nextToken);
        }

        public final Collection<Parent.Builder> getParents() {
            return this.parents != null ? (Collection)this.parents.stream().map(Parent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Parent ... parents) {
            this.parents(Arrays.asList(parents));
            return this;
        }

        public final void setParents(Collection<Parent.BuilderImpl> parents) {
            this.parents = ParentsCopier.copyFromBuilder(parents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListParentsResponse build() {
            return new ListParentsResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListParentsResponse> {
        public Builder parents(Collection<Parent> var1);

        public Builder parents(Parent ... var1);

        public Builder nextToken(String var1);
    }
}

