/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.organizations.model.CreateAccountState;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatesCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCreateAccountStatusRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, ListCreateAccountStatusRequest> {
    private final List<String> states;
    private final String nextToken;
    private final Integer maxResults;

    private ListCreateAccountStatusRequest(BuilderImpl builder) {
        super(builder);
        this.states = builder.states;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<CreateAccountState> states() {
        return TypeConverter.convert(this.states, CreateAccountState::fromValue);
    }

    public List<String> statesStrings() {
        return this.states;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreateAccountStatusRequest)) {
            return false;
        }
        ListCreateAccountStatusRequest other = (ListCreateAccountStatusRequest)((Object)obj);
        return Objects.equals(this.statesStrings(), other.statesStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListCreateAccountStatusRequest").add("States", this.statesStrings()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "States": {
                return Optional.of(clazz.cast(this.statesStrings()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private List<String> states;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreateAccountStatusRequest model) {
            this.states(model.states);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getStates() {
            return this.states;
        }

        @Override
        public final Builder states(Collection<String> states) {
            this.states = CreateAccountStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(String ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = CreateAccountStatesCopier.copy(states);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListCreateAccountStatusRequest build() {
            return new ListCreateAccountStatusRequest(this);
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    CopyableBuilder<Builder, ListCreateAccountStatusRequest> {
        public Builder states(Collection<String> var1);

        public Builder states(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

