/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.ActionType;
import software.amazon.awssdk.services.organizations.model.HandshakePartiesCopier;
import software.amazon.awssdk.services.organizations.model.HandshakeParty;
import software.amazon.awssdk.services.organizations.model.HandshakeResource;
import software.amazon.awssdk.services.organizations.model.HandshakeResourcesCopier;
import software.amazon.awssdk.services.organizations.model.HandshakeState;
import software.amazon.awssdk.services.organizations.transform.HandshakeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Handshake
implements StructuredPojo,
ToCopyableBuilder<Builder, Handshake> {
    private final String id;
    private final String arn;
    private final List<HandshakeParty> parties;
    private final String state;
    private final Instant requestedTimestamp;
    private final Instant expirationTimestamp;
    private final String action;
    private final List<HandshakeResource> resources;

    private Handshake(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.parties = builder.parties;
        this.state = builder.state;
        this.requestedTimestamp = builder.requestedTimestamp;
        this.expirationTimestamp = builder.expirationTimestamp;
        this.action = builder.action;
        this.resources = builder.resources;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public List<HandshakeParty> parties() {
        return this.parties;
    }

    public HandshakeState state() {
        return HandshakeState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Instant requestedTimestamp() {
        return this.requestedTimestamp;
    }

    public Instant expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public ActionType action() {
        return ActionType.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public List<HandshakeResource> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.parties());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Handshake)) {
            return false;
        }
        Handshake other = (Handshake)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.parties(), other.parties()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.requestedTimestamp(), other.requestedTimestamp()) && Objects.equals(this.expirationTimestamp(), other.expirationTimestamp()) && Objects.equals(this.actionString(), other.actionString()) && Objects.equals(this.resources(), other.resources());
    }

    public String toString() {
        return ToString.builder((String)"Handshake").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Parties", this.parties()).add("State", (Object)this.stateString()).add("RequestedTimestamp", (Object)this.requestedTimestamp()).add("ExpirationTimestamp", (Object)this.expirationTimestamp()).add("Action", (Object)this.actionString()).add("Resources", this.resources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Parties": {
                return Optional.of(clazz.cast(this.parties()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "RequestedTimestamp": {
                return Optional.of(clazz.cast(this.requestedTimestamp()));
            }
            case "ExpirationTimestamp": {
                return Optional.of(clazz.cast(this.expirationTimestamp()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "Resources": {
                return Optional.of(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private List<HandshakeParty> parties;
        private String state;
        private Instant requestedTimestamp;
        private Instant expirationTimestamp;
        private String action;
        private List<HandshakeResource> resources;

        private BuilderImpl() {
        }

        private BuilderImpl(Handshake model) {
            this.id(model.id);
            this.arn(model.arn);
            this.parties(model.parties);
            this.state(model.state);
            this.requestedTimestamp(model.requestedTimestamp);
            this.expirationTimestamp(model.expirationTimestamp);
            this.action(model.action);
            this.resources(model.resources);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<HandshakeParty.Builder> getParties() {
            return this.parties != null ? (Collection)this.parties.stream().map(HandshakeParty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parties(Collection<HandshakeParty> parties) {
            this.parties = HandshakePartiesCopier.copy(parties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parties(HandshakeParty ... parties) {
            this.parties(Arrays.asList(parties));
            return this;
        }

        public final void setParties(Collection<HandshakeParty.BuilderImpl> parties) {
            this.parties = HandshakePartiesCopier.copyFromBuilder(parties);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HandshakeState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getRequestedTimestamp() {
            return this.requestedTimestamp;
        }

        @Override
        public final Builder requestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
            return this;
        }

        public final void setRequestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
        }

        public final Instant getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        @Override
        public final Builder expirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
            return this;
        }

        public final void setExpirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionType action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Collection<HandshakeResource.Builder> getResources() {
            return this.resources != null ? (Collection)this.resources.stream().map(HandshakeResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(HandshakeResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<HandshakeResource.BuilderImpl> resources) {
            this.resources = HandshakeResourcesCopier.copyFromBuilder(resources);
        }

        public Handshake build() {
            return new Handshake(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Handshake> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder parties(Collection<HandshakeParty> var1);

        public Builder parties(HandshakeParty ... var1);

        public Builder state(String var1);

        public Builder state(HandshakeState var1);

        public Builder requestedTimestamp(Instant var1);

        public Builder expirationTimestamp(Instant var1);

        public Builder action(String var1);

        public Builder action(ActionType var1);

        public Builder resources(Collection<HandshakeResource> var1);

        public Builder resources(HandshakeResource ... var1);
    }
}

