/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnit;

@SdkInternalApi
public class OrganizationalUnitMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final OrganizationalUnitMarshaller INSTANCE = new OrganizationalUnitMarshaller();

    public static OrganizationalUnitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OrganizationalUnit organizationalUnit, ProtocolMarshaller protocolMarshaller) {
        if (organizationalUnit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)organizationalUnit.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)organizationalUnit.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)organizationalUnit.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

