/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse;

public final class ListOrganizationalUnitsForParentPaginator
implements SdkIterable<ListOrganizationalUnitsForParentResponse> {
    private final OrganizationsClient client;
    private final ListOrganizationalUnitsForParentRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListOrganizationalUnitsForParentPaginator(OrganizationsClient client, ListOrganizationalUnitsForParentRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOrganizationalUnitsForParentResponseFetcher();
    }

    public Iterator<ListOrganizationalUnitsForParentResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListOrganizationalUnitsForParentResponseFetcher
    implements NextPageFetcher<ListOrganizationalUnitsForParentResponse> {
        private ListOrganizationalUnitsForParentResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationalUnitsForParentResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListOrganizationalUnitsForParentResponse nextPage(ListOrganizationalUnitsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationalUnitsForParentPaginator.this.client.listOrganizationalUnitsForParent(ListOrganizationalUnitsForParentPaginator.this.firstRequest);
            }
            return ListOrganizationalUnitsForParentPaginator.this.client.listOrganizationalUnitsForParent((ListOrganizationalUnitsForParentRequest)((Object)ListOrganizationalUnitsForParentPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

