/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet;
import software.amazon.awssdk.services.organizations.model.PolicyTypeSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTypesCopier;
import software.amazon.awssdk.services.organizations.transform.OrganizationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Organization
implements StructuredPojo,
ToCopyableBuilder<Builder, Organization> {
    private final String id;
    private final String arn;
    private final String featureSet;
    private final String masterAccountArn;
    private final String masterAccountId;
    private final String masterAccountEmail;
    private final List<PolicyTypeSummary> availablePolicyTypes;

    private Organization(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.featureSet = builder.featureSet;
        this.masterAccountArn = builder.masterAccountArn;
        this.masterAccountId = builder.masterAccountId;
        this.masterAccountEmail = builder.masterAccountEmail;
        this.availablePolicyTypes = builder.availablePolicyTypes;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public OrganizationFeatureSet featureSet() {
        return OrganizationFeatureSet.fromValue(this.featureSet);
    }

    public String featureSetString() {
        return this.featureSet;
    }

    public String masterAccountArn() {
        return this.masterAccountArn;
    }

    public String masterAccountId() {
        return this.masterAccountId;
    }

    public String masterAccountEmail() {
        return this.masterAccountEmail;
    }

    public List<PolicyTypeSummary> availablePolicyTypes() {
        return this.availablePolicyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureSetString());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccountArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccountEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.availablePolicyTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Organization)) {
            return false;
        }
        Organization other = (Organization)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.featureSetString(), other.featureSetString()) && Objects.equals(this.masterAccountArn(), other.masterAccountArn()) && Objects.equals(this.masterAccountId(), other.masterAccountId()) && Objects.equals(this.masterAccountEmail(), other.masterAccountEmail()) && Objects.equals(this.availablePolicyTypes(), other.availablePolicyTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.featureSetString() != null) {
            sb.append("FeatureSet: ").append(this.featureSetString()).append(",");
        }
        if (this.masterAccountArn() != null) {
            sb.append("MasterAccountArn: ").append(this.masterAccountArn()).append(",");
        }
        if (this.masterAccountId() != null) {
            sb.append("MasterAccountId: ").append(this.masterAccountId()).append(",");
        }
        if (this.masterAccountEmail() != null) {
            sb.append("MasterAccountEmail: ").append(this.masterAccountEmail()).append(",");
        }
        if (this.availablePolicyTypes() != null) {
            sb.append("AvailablePolicyTypes: ").append(this.availablePolicyTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "FeatureSet": {
                return Optional.of(clazz.cast(this.featureSetString()));
            }
            case "MasterAccountArn": {
                return Optional.of(clazz.cast(this.masterAccountArn()));
            }
            case "MasterAccountId": {
                return Optional.of(clazz.cast(this.masterAccountId()));
            }
            case "MasterAccountEmail": {
                return Optional.of(clazz.cast(this.masterAccountEmail()));
            }
            case "AvailablePolicyTypes": {
                return Optional.of(clazz.cast(this.availablePolicyTypes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrganizationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String featureSet;
        private String masterAccountArn;
        private String masterAccountId;
        private String masterAccountEmail;
        private List<PolicyTypeSummary> availablePolicyTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(Organization model) {
            this.id(model.id);
            this.arn(model.arn);
            this.featureSet(model.featureSet);
            this.masterAccountArn(model.masterAccountArn);
            this.masterAccountId(model.masterAccountId);
            this.masterAccountEmail(model.masterAccountEmail);
            this.availablePolicyTypes(model.availablePolicyTypes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getFeatureSet() {
            return this.featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(OrganizationFeatureSet featureSet) {
            this.featureSet(featureSet.toString());
            return this;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        public final String getMasterAccountArn() {
            return this.masterAccountArn;
        }

        @Override
        public final Builder masterAccountArn(String masterAccountArn) {
            this.masterAccountArn = masterAccountArn;
            return this;
        }

        public final void setMasterAccountArn(String masterAccountArn) {
            this.masterAccountArn = masterAccountArn;
        }

        public final String getMasterAccountId() {
            return this.masterAccountId;
        }

        @Override
        public final Builder masterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
            return this;
        }

        public final void setMasterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
        }

        public final String getMasterAccountEmail() {
            return this.masterAccountEmail;
        }

        @Override
        public final Builder masterAccountEmail(String masterAccountEmail) {
            this.masterAccountEmail = masterAccountEmail;
            return this;
        }

        public final void setMasterAccountEmail(String masterAccountEmail) {
            this.masterAccountEmail = masterAccountEmail;
        }

        public final Collection<PolicyTypeSummary.Builder> getAvailablePolicyTypes() {
            return this.availablePolicyTypes != null ? (Collection)this.availablePolicyTypes.stream().map(PolicyTypeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availablePolicyTypes(Collection<PolicyTypeSummary> availablePolicyTypes) {
            this.availablePolicyTypes = PolicyTypesCopier.copy(availablePolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePolicyTypes(PolicyTypeSummary ... availablePolicyTypes) {
            this.availablePolicyTypes(Arrays.asList(availablePolicyTypes));
            return this;
        }

        public final void setAvailablePolicyTypes(Collection<PolicyTypeSummary.BuilderImpl> availablePolicyTypes) {
            this.availablePolicyTypes = PolicyTypesCopier.copyFromBuilder(availablePolicyTypes);
        }

        public Organization build() {
            return new Organization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Organization> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder featureSet(String var1);

        public Builder featureSet(OrganizationFeatureSet var1);

        public Builder masterAccountArn(String var1);

        public Builder masterAccountId(String var1);

        public Builder masterAccountEmail(String var1);

        public Builder availablePolicyTypes(Collection<PolicyTypeSummary> var1);

        public Builder availablePolicyTypes(PolicyTypeSummary ... var1);
    }
}

