/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MoveAccountRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, MoveAccountRequest> {
    private final String accountId;
    private final String sourceParentId;
    private final String destinationParentId;

    private MoveAccountRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.sourceParentId = builder.sourceParentId;
        this.destinationParentId = builder.destinationParentId;
    }

    public String accountId() {
        return this.accountId;
    }

    public String sourceParentId() {
        return this.sourceParentId;
    }

    public String destinationParentId() {
        return this.destinationParentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceParentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationParentId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveAccountRequest)) {
            return false;
        }
        MoveAccountRequest other = (MoveAccountRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.sourceParentId(), other.sourceParentId()) && Objects.equals(this.destinationParentId(), other.destinationParentId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.sourceParentId() != null) {
            sb.append("SourceParentId: ").append(this.sourceParentId()).append(",");
        }
        if (this.destinationParentId() != null) {
            sb.append("DestinationParentId: ").append(this.destinationParentId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "SourceParentId": {
                return Optional.of(clazz.cast(this.sourceParentId()));
            }
            case "DestinationParentId": {
                return Optional.of(clazz.cast(this.destinationParentId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String sourceParentId;
        private String destinationParentId;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveAccountRequest model) {
            this.accountId(model.accountId);
            this.sourceParentId(model.sourceParentId);
            this.destinationParentId(model.destinationParentId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getSourceParentId() {
            return this.sourceParentId;
        }

        @Override
        public final Builder sourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
            return this;
        }

        public final void setSourceParentId(String sourceParentId) {
            this.sourceParentId = sourceParentId;
        }

        public final String getDestinationParentId() {
            return this.destinationParentId;
        }

        @Override
        public final Builder destinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
            return this;
        }

        public final void setDestinationParentId(String destinationParentId) {
            this.destinationParentId = destinationParentId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public MoveAccountRequest build() {
            return new MoveAccountRequest(this);
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    CopyableBuilder<Builder, MoveAccountRequest> {
        public Builder accountId(String var1);

        public Builder sourceParentId(String var1);

        public Builder destinationParentId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

