/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatus;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatusesCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCreateAccountStatusResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListCreateAccountStatusResponse> {
    private final List<CreateAccountStatus> createAccountStatuses;
    private final String nextToken;

    private ListCreateAccountStatusResponse(BuilderImpl builder) {
        super(builder);
        this.createAccountStatuses = builder.createAccountStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<CreateAccountStatus> createAccountStatuses() {
        return this.createAccountStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createAccountStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreateAccountStatusResponse)) {
            return false;
        }
        ListCreateAccountStatusResponse other = (ListCreateAccountStatusResponse)((Object)obj);
        return Objects.equals(this.createAccountStatuses(), other.createAccountStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.createAccountStatuses() != null) {
            sb.append("CreateAccountStatuses: ").append(this.createAccountStatuses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateAccountStatuses": {
                return Optional.of(clazz.cast(this.createAccountStatuses()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<CreateAccountStatus> createAccountStatuses;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreateAccountStatusResponse model) {
            this.createAccountStatuses(model.createAccountStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<CreateAccountStatus.Builder> getCreateAccountStatuses() {
            return this.createAccountStatuses != null ? (Collection)this.createAccountStatuses.stream().map(CreateAccountStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createAccountStatuses(Collection<CreateAccountStatus> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copy(createAccountStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createAccountStatuses(CreateAccountStatus ... createAccountStatuses) {
            this.createAccountStatuses(Arrays.asList(createAccountStatuses));
            return this;
        }

        public final void setCreateAccountStatuses(Collection<CreateAccountStatus.BuilderImpl> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copyFromBuilder(createAccountStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCreateAccountStatusResponse build() {
            return new ListCreateAccountStatusResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListCreateAccountStatusResponse> {
        public Builder createAccountStatuses(Collection<CreateAccountStatus> var1);

        public Builder createAccountStatuses(CreateAccountStatus ... var1);

        public Builder nextToken(String var1);
    }
}

