/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.transform.EnabledServicePrincipalMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnabledServicePrincipal
implements StructuredPojo,
ToCopyableBuilder<Builder, EnabledServicePrincipal> {
    private final String servicePrincipal;
    private final Instant dateEnabled;

    private EnabledServicePrincipal(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.dateEnabled = builder.dateEnabled;
    }

    public String servicePrincipal() {
        return this.servicePrincipal;
    }

    public Instant dateEnabled() {
        return this.dateEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledServicePrincipal)) {
            return false;
        }
        EnabledServicePrincipal other = (EnabledServicePrincipal)obj;
        return Objects.equals(this.servicePrincipal(), other.servicePrincipal()) && Objects.equals(this.dateEnabled(), other.dateEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.servicePrincipal() != null) {
            sb.append("ServicePrincipal: ").append(this.servicePrincipal()).append(",");
        }
        if (this.dateEnabled() != null) {
            sb.append("DateEnabled: ").append(this.dateEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServicePrincipal": {
                return Optional.of(clazz.cast(this.servicePrincipal()));
            }
            case "DateEnabled": {
                return Optional.of(clazz.cast(this.dateEnabled()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnabledServicePrincipalMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String servicePrincipal;
        private Instant dateEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledServicePrincipal model) {
            this.servicePrincipal(model.servicePrincipal);
            this.dateEnabled(model.dateEnabled);
        }

        public final String getServicePrincipal() {
            return this.servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        public final Instant getDateEnabled() {
            return this.dateEnabled;
        }

        @Override
        public final Builder dateEnabled(Instant dateEnabled) {
            this.dateEnabled = dateEnabled;
            return this;
        }

        public final void setDateEnabled(Instant dateEnabled) {
            this.dateEnabled = dateEnabled;
        }

        public EnabledServicePrincipal build() {
            return new EnabledServicePrincipal(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnabledServicePrincipal> {
        public Builder servicePrincipal(String var1);

        public Builder dateEnabled(Instant var1);
    }
}

