/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.services.organizations.model.PolicyType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisablePolicyTypeRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, DisablePolicyTypeRequest> {
    private final String rootId;
    private final String policyType;

    private DisablePolicyTypeRequest(BuilderImpl builder) {
        super(builder);
        this.rootId = builder.rootId;
        this.policyType = builder.policyType;
    }

    public String rootId() {
        return this.rootId;
    }

    public PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public String policyTypeString() {
        return this.policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rootId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisablePolicyTypeRequest)) {
            return false;
        }
        DisablePolicyTypeRequest other = (DisablePolicyTypeRequest)((Object)obj);
        return Objects.equals(this.rootId(), other.rootId()) && Objects.equals(this.policyTypeString(), other.policyTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.rootId() != null) {
            sb.append("RootId: ").append(this.rootId()).append(",");
        }
        if (this.policyTypeString() != null) {
            sb.append("PolicyType: ").append(this.policyTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RootId": {
                return Optional.of(clazz.cast(this.rootId()));
            }
            case "PolicyType": {
                return Optional.of(clazz.cast(this.policyTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String rootId;
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(DisablePolicyTypeRequest model) {
            this.rootId(model.rootId);
            this.policyType(model.policyType);
        }

        public final String getRootId() {
            return this.rootId;
        }

        @Override
        public final Builder rootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public final void setRootId(String rootId) {
            this.rootId = rootId;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DisablePolicyTypeRequest build() {
            return new DisablePolicyTypeRequest(this);
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    CopyableBuilder<Builder, DisablePolicyTypeRequest> {
        public Builder rootId(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

