/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;

public final class ListRootsPaginator
implements SdkIterable<ListRootsResponse> {
    private final OrganizationsClient client;
    private final ListRootsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListRootsPaginator(OrganizationsClient client, ListRootsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRootsResponseFetcher();
    }

    public Iterator<ListRootsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListRootsResponseFetcher
    implements NextPageFetcher<ListRootsResponse> {
        private ListRootsResponseFetcher() {
        }

        public boolean hasNextPage(ListRootsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListRootsResponse nextPage(ListRootsResponse previousPage) {
            if (previousPage == null) {
                return ListRootsPaginator.this.client.listRoots(ListRootsPaginator.this.firstRequest);
            }
            return ListRootsPaginator.this.client.listRoots((ListRootsRequest)((Object)ListRootsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

