/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;

public final class ListPoliciesPaginator
implements SdkIterable<ListPoliciesResponse> {
    private final OrganizationsClient client;
    private final ListPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPoliciesPaginator(OrganizationsClient client, ListPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPoliciesResponseFetcher();
    }

    public Iterator<ListPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListPoliciesResponseFetcher
    implements NextPageFetcher<ListPoliciesResponse> {
        private ListPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListPoliciesResponse nextPage(ListPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesPaginator.this.client.listPolicies(ListPoliciesPaginator.this.firstRequest);
            }
            return ListPoliciesPaginator.this.client.listPolicies((ListPoliciesRequest)((Object)ListPoliciesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

