/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;

public final class ListAccountsForParentPaginator
implements SdkIterable<ListAccountsForParentResponse> {
    private final OrganizationsClient client;
    private final ListAccountsForParentRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAccountsForParentPaginator(OrganizationsClient client, ListAccountsForParentRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountsForParentResponseFetcher();
    }

    public Iterator<ListAccountsForParentResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListAccountsForParentResponseFetcher
    implements NextPageFetcher<ListAccountsForParentResponse> {
        private ListAccountsForParentResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsForParentResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListAccountsForParentResponse nextPage(ListAccountsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsForParentPaginator.this.client.listAccountsForParent(ListAccountsForParentPaginator.this.firstRequest);
            }
            return ListAccountsForParentPaginator.this.client.listAccountsForParent((ListAccountsForParentRequest)((Object)ListAccountsForParentPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

