/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.PolicyTargetSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTargetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTargetsForPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTargetsForPolicyResponse> {
    private final List<PolicyTargetSummary> targets;
    private final String nextToken;

    private ListTargetsForPolicyResponse(BuilderImpl builder) {
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    public List<PolicyTargetSummary> targets() {
        return this.targets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForPolicyResponse)) {
            return false;
        }
        ListTargetsForPolicyResponse other = (ListTargetsForPolicyResponse)((Object)obj);
        return Objects.equals(this.targets(), other.targets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PolicyTargetSummary> targets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsForPolicyResponse model) {
            this.targets(model.targets);
            this.nextToken(model.nextToken);
        }

        public final Collection<PolicyTargetSummary.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(PolicyTargetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<PolicyTargetSummary> targets) {
            this.targets = PolicyTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(PolicyTargetSummary ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<PolicyTargetSummary.BuilderImpl> targets) {
            this.targets = PolicyTargetsCopier.copyFromBuilder(targets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTargetsForPolicyResponse build() {
            return new ListTargetsForPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTargetsForPolicyResponse> {
        public Builder targets(Collection<PolicyTargetSummary> var1);

        public Builder targets(PolicyTargetSummary ... var1);

        public Builder nextToken(String var1);
    }
}

