/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListParentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListParentsRequest> {
    private final String childId;
    private final String nextToken;
    private final Integer maxResults;

    private ListParentsRequest(BuilderImpl builder) {
        this.childId = builder.childId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String childId() {
        return this.childId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.childId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParentsRequest)) {
            return false;
        }
        ListParentsRequest other = (ListParentsRequest)((Object)obj);
        return Objects.equals(this.childId(), other.childId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.childId() != null) {
            sb.append("ChildId: ").append(this.childId()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChildId": {
                return Optional.of(clazz.cast(this.childId()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String childId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParentsRequest model) {
            this.childId(model.childId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getChildId() {
            return this.childId;
        }

        @Override
        public final Builder childId(String childId) {
            this.childId = childId;
            return this;
        }

        public final void setChildId(String childId) {
            this.childId = childId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public ListParentsRequest build() {
            return new ListParentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListParentsRequest> {
        public Builder childId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

