/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdatePolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdatePolicyRequest> {
    private final String policyId;
    private final String name;
    private final String description;
    private final String content;

    private UpdatePolicyRequest(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.name = builder.name;
        this.description = builder.description;
        this.content = builder.content;
    }

    public String policyId() {
        return this.policyId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyId() == null ? 0 : this.policyId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.content() == null ? 0 : this.content().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePolicyRequest)) {
            return false;
        }
        UpdatePolicyRequest other = (UpdatePolicyRequest)((Object)obj);
        if (other.policyId() == null ^ this.policyId() == null) {
            return false;
        }
        if (other.policyId() != null && !other.policyId().equals(this.policyId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        return other.content() == null || other.content().equals(this.content());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyId() != null) {
            sb.append("PolicyId: ").append(this.policyId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.of(clazz.cast(this.policyId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String name;
        private String description;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePolicyRequest model) {
            this.policyId(model.policyId);
            this.name(model.name);
            this.description(model.description);
            this.content(model.content);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public UpdatePolicyRequest build() {
            return new UpdatePolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdatePolicyRequest> {
        public Builder policyId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder content(String var1);
    }
}

