/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.PolicySummary;
import software.amazon.awssdk.services.organizations.transform.PolicyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Policy
implements StructuredPojo,
ToCopyableBuilder<Builder, Policy> {
    private final PolicySummary policySummary;
    private final String content;

    private Policy(BuilderImpl builder) {
        this.policySummary = builder.policySummary;
        this.content = builder.content;
    }

    public PolicySummary policySummary() {
        return this.policySummary;
    }

    public String content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policySummary() == null ? 0 : this.policySummary().hashCode());
        hashCode = 31 * hashCode + (this.content() == null ? 0 : this.content().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        if (other.policySummary() == null ^ this.policySummary() == null) {
            return false;
        }
        if (other.policySummary() != null && !other.policySummary().equals(this.policySummary())) {
            return false;
        }
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        return other.content() == null || other.content().equals(this.content());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policySummary() != null) {
            sb.append("PolicySummary: ").append(this.policySummary()).append(",");
        }
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicySummary": {
                return Optional.of(clazz.cast(this.policySummary()));
            }
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private PolicySummary policySummary;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            this.policySummary(model.policySummary);
            this.content(model.content);
        }

        public final PolicySummary.Builder getPolicySummary() {
            return this.policySummary != null ? this.policySummary.toBuilder() : null;
        }

        @Override
        public final Builder policySummary(PolicySummary policySummary) {
            this.policySummary = policySummary;
            return this;
        }

        public final void setPolicySummary(PolicySummary.BuilderImpl policySummary) {
            this.policySummary = policySummary != null ? policySummary.build() : null;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public Policy build() {
            return new Policy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Policy> {
        public Builder policySummary(PolicySummary var1);

        public Builder content(String var1);
    }
}

