/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.Root;
import software.amazon.awssdk.services.organizations.model.RootsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRootsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRootsResponse> {
    private final List<Root> roots;
    private final String nextToken;

    private ListRootsResponse(BuilderImpl builder) {
        this.roots = builder.roots;
        this.nextToken = builder.nextToken;
    }

    public List<Root> roots() {
        return this.roots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roots() == null ? 0 : this.roots().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRootsResponse)) {
            return false;
        }
        ListRootsResponse other = (ListRootsResponse)((Object)obj);
        if (other.roots() == null ^ this.roots() == null) {
            return false;
        }
        if (other.roots() != null && !other.roots().equals(this.roots())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roots() != null) {
            sb.append("Roots: ").append(this.roots()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Roots": {
                return Optional.of(clazz.cast(this.roots()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Root> roots;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRootsResponse model) {
            this.roots(model.roots);
            this.nextToken(model.nextToken);
        }

        public final Collection<Root.Builder> getRoots() {
            return this.roots != null ? (Collection)this.roots.stream().map(Root::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roots(Collection<Root> roots) {
            this.roots = RootsCopier.copy(roots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roots(Root ... roots) {
            this.roots(Arrays.asList(roots));
            return this;
        }

        public final void setRoots(Collection<Root.BuilderImpl> roots) {
            this.roots = RootsCopier.copyFromBuilder(roots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListRootsResponse build() {
            return new ListRootsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRootsResponse> {
        public Builder roots(Collection<Root> var1);

        public Builder roots(Root ... var1);

        public Builder nextToken(String var1);
    }
}

