/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOrganizationalUnitsForParentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListOrganizationalUnitsForParentRequest> {
    private final String parentId;
    private final String nextToken;
    private final Integer maxResults;

    private ListOrganizationalUnitsForParentRequest(BuilderImpl builder) {
        this.parentId = builder.parentId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String parentId() {
        return this.parentId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parentId() == null ? 0 : this.parentId().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationalUnitsForParentRequest)) {
            return false;
        }
        ListOrganizationalUnitsForParentRequest other = (ListOrganizationalUnitsForParentRequest)((Object)obj);
        if (other.parentId() == null ^ this.parentId() == null) {
            return false;
        }
        if (other.parentId() != null && !other.parentId().equals(this.parentId())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parentId() != null) {
            sb.append("ParentId: ").append(this.parentId()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentId": {
                return Optional.of(clazz.cast(this.parentId()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parentId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationalUnitsForParentRequest model) {
            this.parentId(model.parentId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public ListOrganizationalUnitsForParentRequest build() {
            return new ListOrganizationalUnitsForParentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOrganizationalUnitsForParentRequest> {
        public Builder parentId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

