/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.Handshake;
import software.amazon.awssdk.services.organizations.model.HandshakesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHandshakesForAccountResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListHandshakesForAccountResponse> {
    private final List<Handshake> handshakes;
    private final String nextToken;

    private ListHandshakesForAccountResponse(BuilderImpl builder) {
        this.handshakes = builder.handshakes;
        this.nextToken = builder.nextToken;
    }

    public List<Handshake> handshakes() {
        return this.handshakes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.handshakes() == null ? 0 : this.handshakes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHandshakesForAccountResponse)) {
            return false;
        }
        ListHandshakesForAccountResponse other = (ListHandshakesForAccountResponse)((Object)obj);
        if (other.handshakes() == null ^ this.handshakes() == null) {
            return false;
        }
        if (other.handshakes() != null && !other.handshakes().equals(this.handshakes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.handshakes() != null) {
            sb.append("Handshakes: ").append(this.handshakes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Handshakes": {
                return Optional.of(clazz.cast(this.handshakes()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Handshake> handshakes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHandshakesForAccountResponse model) {
            this.handshakes(model.handshakes);
            this.nextToken(model.nextToken);
        }

        public final Collection<Handshake.Builder> getHandshakes() {
            return this.handshakes != null ? (Collection)this.handshakes.stream().map(Handshake::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder handshakes(Collection<Handshake> handshakes) {
            this.handshakes = HandshakesCopier.copy(handshakes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Handshake ... handshakes) {
            this.handshakes(Arrays.asList(handshakes));
            return this;
        }

        public final void setHandshakes(Collection<Handshake.BuilderImpl> handshakes) {
            this.handshakes = HandshakesCopier.copyFromBuilder(handshakes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListHandshakesForAccountResponse build() {
            return new ListHandshakesForAccountResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHandshakesForAccountResponse> {
        public Builder handshakes(Collection<Handshake> var1);

        public Builder handshakes(Handshake ... var1);

        public Builder nextToken(String var1);
    }
}

