/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.organizations.model.IAMUserAccessToBilling;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAccountRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateAccountRequest> {
    private final String email;
    private final String accountName;
    private final String roleName;
    private final String iamUserAccessToBilling;

    private CreateAccountRequest(BuilderImpl builder) {
        this.email = builder.email;
        this.accountName = builder.accountName;
        this.roleName = builder.roleName;
        this.iamUserAccessToBilling = builder.iamUserAccessToBilling;
    }

    public String email() {
        return this.email;
    }

    public String accountName() {
        return this.accountName;
    }

    public String roleName() {
        return this.roleName;
    }

    public IAMUserAccessToBilling iamUserAccessToBilling() {
        return IAMUserAccessToBilling.fromValue(this.iamUserAccessToBilling);
    }

    public String iamUserAccessToBillingString() {
        return this.iamUserAccessToBilling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.email() == null ? 0 : this.email().hashCode());
        hashCode = 31 * hashCode + (this.accountName() == null ? 0 : this.accountName().hashCode());
        hashCode = 31 * hashCode + (this.roleName() == null ? 0 : this.roleName().hashCode());
        hashCode = 31 * hashCode + (this.iamUserAccessToBillingString() == null ? 0 : this.iamUserAccessToBillingString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountRequest)) {
            return false;
        }
        CreateAccountRequest other = (CreateAccountRequest)((Object)obj);
        if (other.email() == null ^ this.email() == null) {
            return false;
        }
        if (other.email() != null && !other.email().equals(this.email())) {
            return false;
        }
        if (other.accountName() == null ^ this.accountName() == null) {
            return false;
        }
        if (other.accountName() != null && !other.accountName().equals(this.accountName())) {
            return false;
        }
        if (other.roleName() == null ^ this.roleName() == null) {
            return false;
        }
        if (other.roleName() != null && !other.roleName().equals(this.roleName())) {
            return false;
        }
        if (other.iamUserAccessToBillingString() == null ^ this.iamUserAccessToBillingString() == null) {
            return false;
        }
        return other.iamUserAccessToBillingString() == null || other.iamUserAccessToBillingString().equals(this.iamUserAccessToBillingString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.email() != null) {
            sb.append("Email: ").append(this.email()).append(",");
        }
        if (this.accountName() != null) {
            sb.append("AccountName: ").append(this.accountName()).append(",");
        }
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        if (this.iamUserAccessToBillingString() != null) {
            sb.append("IamUserAccessToBilling: ").append(this.iamUserAccessToBillingString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Email": {
                return Optional.of(clazz.cast(this.email()));
            }
            case "AccountName": {
                return Optional.of(clazz.cast(this.accountName()));
            }
            case "RoleName": {
                return Optional.of(clazz.cast(this.roleName()));
            }
            case "IamUserAccessToBilling": {
                return Optional.of(clazz.cast(this.iamUserAccessToBillingString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String email;
        private String accountName;
        private String roleName;
        private String iamUserAccessToBilling;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountRequest model) {
            this.email(model.email);
            this.accountName(model.accountName);
            this.roleName(model.roleName);
            this.iamUserAccessToBilling(model.iamUserAccessToBilling);
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getIamUserAccessToBilling() {
            return this.iamUserAccessToBilling;
        }

        @Override
        public final Builder iamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
            return this;
        }

        @Override
        public final Builder iamUserAccessToBilling(IAMUserAccessToBilling iamUserAccessToBilling) {
            this.iamUserAccessToBilling(iamUserAccessToBilling.toString());
            return this;
        }

        public final void setIamUserAccessToBilling(String iamUserAccessToBilling) {
            this.iamUserAccessToBilling = iamUserAccessToBilling;
        }

        public CreateAccountRequest build() {
            return new CreateAccountRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAccountRequest> {
        public Builder email(String var1);

        public Builder accountName(String var1);

        public Builder roleName(String var1);

        public Builder iamUserAccessToBilling(String var1);

        public Builder iamUserAccessToBilling(IAMUserAccessToBilling var1);
    }
}

