/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ActionType {
    INVITE("INVITE"),
    ENABLE_ALL_FEATURES("ENABLE_ALL_FEATURES"),
    APPROVE_ALL_FEATURES("APPROVE_ALL_FEATURES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionType> knownValues() {
        return Stream.of(ActionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

