/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.AWSOrganizationsNotInUseException;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.AccessDeniedException;
import software.amazon.awssdk.services.organizations.model.AccountNotFoundException;
import software.amazon.awssdk.services.organizations.model.AlreadyInOrganizationException;
import software.amazon.awssdk.services.organizations.model.AttachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.AttachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.ChildNotFoundException;
import software.amazon.awssdk.services.organizations.model.ConcurrentModificationException;
import software.amazon.awssdk.services.organizations.model.ConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.CreateAccountRequest;
import software.amazon.awssdk.services.organizations.model.CreateAccountResponse;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatusNotFoundException;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.CreatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.CreatePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DeletePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DeletePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DescribeAccountRequest;
import software.amazon.awssdk.services.organizations.model.DescribeAccountResponse;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest;
import software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.DescribePolicyRequest;
import software.amazon.awssdk.services.organizations.model.DescribePolicyResponse;
import software.amazon.awssdk.services.organizations.model.DestinationParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.DetachPolicyRequest;
import software.amazon.awssdk.services.organizations.model.DetachPolicyResponse;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.DuplicateAccountException;
import software.amazon.awssdk.services.organizations.model.DuplicateHandshakeException;
import software.amazon.awssdk.services.organizations.model.DuplicateOrganizationalUnitException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyAttachmentException;
import software.amazon.awssdk.services.organizations.model.DuplicatePolicyException;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesRequest;
import software.amazon.awssdk.services.organizations.model.EnableAllFeaturesResponse;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest;
import software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse;
import software.amazon.awssdk.services.organizations.model.FinalizingOrganizationException;
import software.amazon.awssdk.services.organizations.model.HandshakeAlreadyInStateException;
import software.amazon.awssdk.services.organizations.model.HandshakeConstraintViolationException;
import software.amazon.awssdk.services.organizations.model.HandshakeNotFoundException;
import software.amazon.awssdk.services.organizations.model.InvalidHandshakeTransitionException;
import software.amazon.awssdk.services.organizations.model.InvalidInputException;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.LeaveOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest;
import software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.organizations.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.organizations.model.MasterCannotLeaveOrganizationException;
import software.amazon.awssdk.services.organizations.model.MoveAccountRequest;
import software.amazon.awssdk.services.organizations.model.MoveAccountResponse;
import software.amazon.awssdk.services.organizations.model.OrganizationNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotEmptyException;
import software.amazon.awssdk.services.organizations.model.OrganizationalUnitNotFoundException;
import software.amazon.awssdk.services.organizations.model.OrganizationsException;
import software.amazon.awssdk.services.organizations.model.ParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyInUseException;
import software.amazon.awssdk.services.organizations.model.PolicyNotAttachedException;
import software.amazon.awssdk.services.organizations.model.PolicyNotFoundException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeAlreadyEnabledException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotAvailableForOrganizationException;
import software.amazon.awssdk.services.organizations.model.PolicyTypeNotEnabledException;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationResponse;
import software.amazon.awssdk.services.organizations.model.RootNotFoundException;
import software.amazon.awssdk.services.organizations.model.ServiceException;
import software.amazon.awssdk.services.organizations.model.SourceParentNotFoundException;
import software.amazon.awssdk.services.organizations.model.TargetNotFoundException;
import software.amazon.awssdk.services.organizations.model.TooManyRequestsException;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest;
import software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest;
import software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse;
import software.amazon.awssdk.services.organizations.transform.AcceptHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.AcceptHandshakeResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.AttachPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.CancelHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CancelHandshakeResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateAccountResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreateOrganizationalUnitResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.CreatePolicyResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DeclineHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeclineHandshakeResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeleteOrganizationalUnitResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DeletePolicyResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeAccountResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeCreateAccountStatusResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeHandshakeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeHandshakeResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribeOrganizationalUnitResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DescribePolicyResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DetachPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.DisablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.DisablePolicyTypeResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAllFeaturesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnableAllFeaturesResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.EnablePolicyTypeRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.EnablePolicyTypeResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.InviteAccountToOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.InviteAccountToOrganizationResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.LeaveOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.LeaveOrganizationResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsForParentResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListAccountsResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListChildrenRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListChildrenResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListCreateAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListCreateAccountStatusResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForAccountResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListHandshakesForOrganizationResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListOrganizationalUnitsForParentRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListOrganizationalUnitsForParentResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListParentsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListParentsResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesForTargetRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesForTargetResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListRootsRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListRootsResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.ListTargetsForPolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.ListTargetsForPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.MoveAccountRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.MoveAccountResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.RemoveAccountFromOrganizationRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.RemoveAccountFromOrganizationResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdateOrganizationalUnitRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdateOrganizationalUnitResponseUnmarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdatePolicyRequestMarshaller;
import software.amazon.awssdk.services.organizations.transform.UpdatePolicyResponseUnmarshaller;

@SdkInternalApi
final class DefaultOrganizationsAsyncClient
implements OrganizationsAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultOrganizationsAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
    }

    @Override
    public CompletableFuture<AcceptHandshakeResponse> acceptHandshake(AcceptHandshakeRequest acceptHandshakeRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptHandshakeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AcceptHandshakeRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptHandshakeRequest));
    }

    @Override
    public CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AttachPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AttachPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachPolicyRequest));
    }

    @Override
    public CompletableFuture<CancelHandshakeResponse> cancelHandshake(CancelHandshakeRequest cancelHandshakeRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelHandshakeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CancelHandshakeRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelHandshakeRequest));
    }

    @Override
    public CompletableFuture<CreateAccountResponse> createAccount(CreateAccountRequest createAccountRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAccountResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateAccountRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAccountRequest));
    }

    @Override
    public CompletableFuture<CreateOrganizationResponse> createOrganization(CreateOrganizationRequest createOrganizationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateOrganizationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateOrganizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationRequest));
    }

    @Override
    public CompletableFuture<CreateOrganizationalUnitResponse> createOrganizationalUnit(CreateOrganizationalUnitRequest createOrganizationalUnitRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateOrganizationalUnitResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateOrganizationalUnitRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrganizationalUnitRequest));
    }

    @Override
    public CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreatePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPolicyRequest));
    }

    @Override
    public CompletableFuture<DeclineHandshakeResponse> declineHandshake(DeclineHandshakeRequest declineHandshakeRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeclineHandshakeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeclineHandshakeRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineHandshakeRequest));
    }

    @Override
    public CompletableFuture<DeleteOrganizationResponse> deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteOrganizationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteOrganizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationRequest));
    }

    @Override
    public CompletableFuture<DeleteOrganizationalUnitResponse> deleteOrganizationalUnit(DeleteOrganizationalUnitRequest deleteOrganizationalUnitRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteOrganizationalUnitResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteOrganizationalUnitRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteOrganizationalUnitRequest));
    }

    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeletePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest));
    }

    @Override
    public CompletableFuture<DescribeAccountResponse> describeAccount(DescribeAccountRequest describeAccountRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAccountResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAccountRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountRequest));
    }

    @Override
    public CompletableFuture<DescribeCreateAccountStatusResponse> describeCreateAccountStatus(DescribeCreateAccountStatusRequest describeCreateAccountStatusRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCreateAccountStatusResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeCreateAccountStatusRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCreateAccountStatusRequest));
    }

    @Override
    public CompletableFuture<DescribeHandshakeResponse> describeHandshake(DescribeHandshakeRequest describeHandshakeRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHandshakeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeHandshakeRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHandshakeRequest));
    }

    @Override
    public CompletableFuture<DescribeOrganizationResponse> describeOrganization(DescribeOrganizationRequest describeOrganizationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOrganizationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeOrganizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationRequest));
    }

    @Override
    public CompletableFuture<DescribeOrganizationalUnitResponse> describeOrganizationalUnit(DescribeOrganizationalUnitRequest describeOrganizationalUnitRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOrganizationalUnitResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeOrganizationalUnitRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationalUnitRequest));
    }

    @Override
    public CompletableFuture<DescribePolicyResponse> describePolicy(DescribePolicyRequest describePolicyRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePolicyRequest));
    }

    @Override
    public CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetachPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DetachPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachPolicyRequest));
    }

    @Override
    public CompletableFuture<DisablePolicyTypeResponse> disablePolicyType(DisablePolicyTypeRequest disablePolicyTypeRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisablePolicyTypeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DisablePolicyTypeRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disablePolicyTypeRequest));
    }

    @Override
    public CompletableFuture<EnableAllFeaturesResponse> enableAllFeatures(EnableAllFeaturesRequest enableAllFeaturesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableAllFeaturesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new EnableAllFeaturesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAllFeaturesRequest));
    }

    @Override
    public CompletableFuture<EnablePolicyTypeResponse> enablePolicyType(EnablePolicyTypeRequest enablePolicyTypeRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnablePolicyTypeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new EnablePolicyTypeRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enablePolicyTypeRequest));
    }

    @Override
    public CompletableFuture<InviteAccountToOrganizationResponse> inviteAccountToOrganization(InviteAccountToOrganizationRequest inviteAccountToOrganizationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InviteAccountToOrganizationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new InviteAccountToOrganizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)inviteAccountToOrganizationRequest));
    }

    @Override
    public CompletableFuture<LeaveOrganizationResponse> leaveOrganization(LeaveOrganizationRequest leaveOrganizationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new LeaveOrganizationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new LeaveOrganizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)leaveOrganizationRequest));
    }

    @Override
    public CompletableFuture<ListAccountsResponse> listAccounts(ListAccountsRequest listAccountsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAccountsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListAccountsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsRequest));
    }

    @Override
    public CompletableFuture<ListAccountsForParentResponse> listAccountsForParent(ListAccountsForParentRequest listAccountsForParentRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAccountsForParentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListAccountsForParentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountsForParentRequest));
    }

    @Override
    public CompletableFuture<ListChildrenResponse> listChildren(ListChildrenRequest listChildrenRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChildrenResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListChildrenRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listChildrenRequest));
    }

    @Override
    public CompletableFuture<ListCreateAccountStatusResponse> listCreateAccountStatus(ListCreateAccountStatusRequest listCreateAccountStatusRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCreateAccountStatusResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListCreateAccountStatusRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCreateAccountStatusRequest));
    }

    @Override
    public CompletableFuture<ListHandshakesForAccountResponse> listHandshakesForAccount(ListHandshakesForAccountRequest listHandshakesForAccountRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHandshakesForAccountResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListHandshakesForAccountRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForAccountRequest));
    }

    @Override
    public CompletableFuture<ListHandshakesForOrganizationResponse> listHandshakesForOrganization(ListHandshakesForOrganizationRequest listHandshakesForOrganizationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHandshakesForOrganizationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListHandshakesForOrganizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHandshakesForOrganizationRequest));
    }

    @Override
    public CompletableFuture<ListOrganizationalUnitsForParentResponse> listOrganizationalUnitsForParent(ListOrganizationalUnitsForParentRequest listOrganizationalUnitsForParentRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOrganizationalUnitsForParentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListOrganizationalUnitsForParentRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOrganizationalUnitsForParentRequest));
    }

    @Override
    public CompletableFuture<ListParentsResponse> listParents(ListParentsRequest listParentsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListParentsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListParentsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listParentsRequest));
    }

    @Override
    public CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPoliciesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListPoliciesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesRequest));
    }

    @Override
    public CompletableFuture<ListPoliciesForTargetResponse> listPoliciesForTarget(ListPoliciesForTargetRequest listPoliciesForTargetRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPoliciesForTargetResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListPoliciesForTargetRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesForTargetRequest));
    }

    @Override
    public CompletableFuture<ListRootsResponse> listRoots(ListRootsRequest listRootsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRootsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListRootsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRootsRequest));
    }

    @Override
    public CompletableFuture<ListTargetsForPolicyResponse> listTargetsForPolicy(ListTargetsForPolicyRequest listTargetsForPolicyRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTargetsForPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTargetsForPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTargetsForPolicyRequest));
    }

    @Override
    public CompletableFuture<MoveAccountResponse> moveAccount(MoveAccountRequest moveAccountRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new MoveAccountResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new MoveAccountRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)moveAccountRequest));
    }

    @Override
    public CompletableFuture<RemoveAccountFromOrganizationResponse> removeAccountFromOrganization(RemoveAccountFromOrganizationRequest removeAccountFromOrganizationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveAccountFromOrganizationResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RemoveAccountFromOrganizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeAccountFromOrganizationRequest));
    }

    @Override
    public CompletableFuture<UpdateOrganizationalUnitResponse> updateOrganizationalUnit(UpdateOrganizationalUnitRequest updateOrganizationalUnitRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateOrganizationalUnitResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateOrganizationalUnitRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateOrganizationalUnitRequest));
    }

    @Override
    public CompletableFuture<UpdatePolicyResponse> updatePolicy(UpdatePolicyRequest updatePolicyRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdatePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePolicyRequest));
    }

    public void close() {
        this.clientHandler.close();
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(OrganizationsException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyTypeNotAvailableForOrganizationException").withModeledClass(PolicyTypeNotAvailableForOrganizationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("HandshakeNotFoundException").withModeledClass(HandshakeNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateAccountException").withModeledClass(DuplicateAccountException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MalformedPolicyDocumentException").withModeledClass(MalformedPolicyDocumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateHandshakeException").withModeledClass(DuplicateHandshakeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicatePolicyException").withModeledClass(DuplicatePolicyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("HandshakeAlreadyInStateException").withModeledClass(HandshakeAlreadyInStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ChildNotFoundException").withModeledClass(ChildNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceException").withModeledClass(ServiceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RootNotFoundException").withModeledClass(RootNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OrganizationNotEmptyException").withModeledClass(OrganizationNotEmptyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OrganizationalUnitNotFoundException").withModeledClass(OrganizationalUnitNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyNotFoundException").withModeledClass(PolicyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyTypeAlreadyEnabledException").withModeledClass(PolicyTypeAlreadyEnabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicatePolicyAttachmentException").withModeledClass(DuplicatePolicyAttachmentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MasterCannotLeaveOrganizationException").withModeledClass(MasterCannotLeaveOrganizationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DestinationParentNotFoundException").withModeledClass(DestinationParentNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyTypeNotEnabledException").withModeledClass(PolicyTypeNotEnabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConstraintViolationException").withModeledClass(ConstraintViolationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TargetNotFoundException").withModeledClass(TargetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CreateAccountStatusNotFoundException").withModeledClass(CreateAccountStatusNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyNotAttachedException").withModeledClass(PolicyNotAttachedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyInOrganizationException").withModeledClass(AlreadyInOrganizationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountNotFoundException").withModeledClass(AccountNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SourceParentNotFoundException").withModeledClass(SourceParentNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AWSOrganizationsNotInUseException").withModeledClass(AWSOrganizationsNotInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ParentNotFoundException").withModeledClass(ParentNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateOrganizationalUnitException").withModeledClass(DuplicateOrganizationalUnitException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidHandshakeTransitionException").withModeledClass(InvalidHandshakeTransitionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("HandshakeConstraintViolationException").withModeledClass(HandshakeConstraintViolationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyInUseException").withModeledClass(PolicyInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FinalizingOrganizationException").withModeledClass(FinalizingOrganizationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OrganizationalUnitNotEmptyException").withModeledClass(OrganizationalUnitNotEmptyException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

