/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.Account;
import software.amazon.awssdk.services.organizations.model.AccountsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAccountsForParentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAccountsForParentResponse> {
    private final List<Account> accounts;
    private final String nextToken;

    private ListAccountsForParentResponse(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.nextToken = builder.nextToken;
    }

    public List<Account> accounts() {
        return this.accounts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accounts() == null ? 0 : this.accounts().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsForParentResponse)) {
            return false;
        }
        ListAccountsForParentResponse other = (ListAccountsForParentResponse)((Object)obj);
        if (other.accounts() == null ^ this.accounts() == null) {
            return false;
        }
        if (other.accounts() != null && !other.accounts().equals(this.accounts())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accounts() != null) {
            sb.append("Accounts: ").append(this.accounts()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Account> accounts;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsForParentResponse model) {
            this.setAccounts(model.accounts);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Account> getAccounts() {
            return this.accounts;
        }

        @Override
        public final Builder accounts(Collection<Account> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Account ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<Account> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListAccountsForParentResponse build() {
            return new ListAccountsForParentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAccountsForParentResponse> {
        public Builder accounts(Collection<Account> var1);

        public Builder accounts(Account ... var1);

        public Builder nextToken(String var1);
    }
}

