/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.HandshakeResourceType;
import software.amazon.awssdk.services.organizations.model.HandshakeResourcesCopier;
import software.amazon.awssdk.services.organizations.transform.HandshakeResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HandshakeResource
implements StructuredPojo,
ToCopyableBuilder<Builder, HandshakeResource> {
    private final String value;
    private final String type;
    private final List<HandshakeResource> resources;

    private HandshakeResource(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.resources = builder.resources;
    }

    public String value() {
        return this.value;
    }

    public String type() {
        return this.type;
    }

    public List<HandshakeResource> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.resources() == null ? 0 : this.resources().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeResource)) {
            return false;
        }
        HandshakeResource other = (HandshakeResource)obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        return other.resources() == null || other.resources().equals(this.resources());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String value;
        private String type;
        private List<HandshakeResource> resources;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeResource model) {
            this.setValue(model.value);
            this.setType(model.type);
            this.setResources(model.resources);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HandshakeResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<HandshakeResource> getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(HandshakeResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
        }

        public HandshakeResource build() {
            return new HandshakeResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HandshakeResource> {
        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(HandshakeResourceType var1);

        public Builder resources(Collection<HandshakeResource> var1);

        public Builder resources(HandshakeResource ... var1);
    }
}

