/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.ActionType;
import software.amazon.awssdk.services.organizations.model.HandshakePartiesCopier;
import software.amazon.awssdk.services.organizations.model.HandshakeParty;
import software.amazon.awssdk.services.organizations.model.HandshakeResource;
import software.amazon.awssdk.services.organizations.model.HandshakeResourcesCopier;
import software.amazon.awssdk.services.organizations.model.HandshakeState;
import software.amazon.awssdk.services.organizations.transform.HandshakeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Handshake
implements StructuredPojo,
ToCopyableBuilder<Builder, Handshake> {
    private final String id;
    private final String arn;
    private final List<HandshakeParty> parties;
    private final String state;
    private final Instant requestedTimestamp;
    private final Instant expirationTimestamp;
    private final String action;
    private final List<HandshakeResource> resources;

    private Handshake(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.parties = builder.parties;
        this.state = builder.state;
        this.requestedTimestamp = builder.requestedTimestamp;
        this.expirationTimestamp = builder.expirationTimestamp;
        this.action = builder.action;
        this.resources = builder.resources;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public List<HandshakeParty> parties() {
        return this.parties;
    }

    public String state() {
        return this.state;
    }

    public Instant requestedTimestamp() {
        return this.requestedTimestamp;
    }

    public Instant expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public String action() {
        return this.action;
    }

    public List<HandshakeResource> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.parties() == null ? 0 : this.parties().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.requestedTimestamp() == null ? 0 : this.requestedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.expirationTimestamp() == null ? 0 : this.expirationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.resources() == null ? 0 : this.resources().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Handshake)) {
            return false;
        }
        Handshake other = (Handshake)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.parties() == null ^ this.parties() == null) {
            return false;
        }
        if (other.parties() != null && !other.parties().equals(this.parties())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.requestedTimestamp() == null ^ this.requestedTimestamp() == null) {
            return false;
        }
        if (other.requestedTimestamp() != null && !other.requestedTimestamp().equals(this.requestedTimestamp())) {
            return false;
        }
        if (other.expirationTimestamp() == null ^ this.expirationTimestamp() == null) {
            return false;
        }
        if (other.expirationTimestamp() != null && !other.expirationTimestamp().equals(this.expirationTimestamp())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        return other.resources() == null || other.resources().equals(this.resources());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.parties() != null) {
            sb.append("Parties: ").append(this.parties()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.requestedTimestamp() != null) {
            sb.append("RequestedTimestamp: ").append(this.requestedTimestamp()).append(",");
        }
        if (this.expirationTimestamp() != null) {
            sb.append("ExpirationTimestamp: ").append(this.expirationTimestamp()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private List<HandshakeParty> parties;
        private String state;
        private Instant requestedTimestamp;
        private Instant expirationTimestamp;
        private String action;
        private List<HandshakeResource> resources;

        private BuilderImpl() {
        }

        private BuilderImpl(Handshake model) {
            this.setId(model.id);
            this.setArn(model.arn);
            this.setParties(model.parties);
            this.setState(model.state);
            this.setRequestedTimestamp(model.requestedTimestamp);
            this.setExpirationTimestamp(model.expirationTimestamp);
            this.setAction(model.action);
            this.setResources(model.resources);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<HandshakeParty> getParties() {
            return this.parties;
        }

        @Override
        public final Builder parties(Collection<HandshakeParty> parties) {
            this.parties = HandshakePartiesCopier.copy(parties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parties(HandshakeParty ... parties) {
            this.parties(Arrays.asList(parties));
            return this;
        }

        public final void setParties(Collection<HandshakeParty> parties) {
            this.parties = HandshakePartiesCopier.copy(parties);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HandshakeState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getRequestedTimestamp() {
            return this.requestedTimestamp;
        }

        @Override
        public final Builder requestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
            return this;
        }

        public final void setRequestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
        }

        public final Instant getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        @Override
        public final Builder expirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
            return this;
        }

        public final void setExpirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionType action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Collection<HandshakeResource> getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(HandshakeResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
        }

        public Handshake build() {
            return new Handshake(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Handshake> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder parties(Collection<HandshakeParty> var1);

        public Builder parties(HandshakeParty ... var1);

        public Builder state(String var1);

        public Builder state(HandshakeState var1);

        public Builder requestedTimestamp(Instant var1);

        public Builder expirationTimestamp(Instant var1);

        public Builder action(String var1);

        public Builder action(ActionType var1);

        public Builder resources(Collection<HandshakeResource> var1);

        public Builder resources(HandshakeResource ... var1);
    }
}

