/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.Organization;

@SdkInternalApi
public class OrganizationMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> FEATURESET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureSet").build();
    private static final MarshallingInfo<String> MASTERACCOUNTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterAccountArn").build();
    private static final MarshallingInfo<String> MASTERACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterAccountId").build();
    private static final MarshallingInfo<String> MASTERACCOUNTEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterAccountEmail").build();
    private static final MarshallingInfo<List> AVAILABLEPOLICYTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailablePolicyTypes").build();
    private static final OrganizationMarshaller instance = new OrganizationMarshaller();

    public static OrganizationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Organization organization, ProtocolMarshaller protocolMarshaller) {
        if (organization == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)organization.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)organization.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)organization.featureSet(), FEATURESET_BINDING);
            protocolMarshaller.marshall((Object)organization.masterAccountArn(), MASTERACCOUNTARN_BINDING);
            protocolMarshaller.marshall((Object)organization.masterAccountId(), MASTERACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)organization.masterAccountEmail(), MASTERACCOUNTEMAIL_BINDING);
            protocolMarshaller.marshall(organization.availablePolicyTypes(), AVAILABLEPOLICYTYPES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

