/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.PolicyTypeSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTypesCopier;
import software.amazon.awssdk.services.organizations.transform.RootMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Root
implements StructuredPojo,
ToCopyableBuilder<Builder, Root> {
    private final String id;
    private final String arn;
    private final String name;
    private final List<PolicyTypeSummary> policyTypes;

    private Root(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.policyTypes = builder.policyTypes;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public List<PolicyTypeSummary> policyTypes() {
        return this.policyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.policyTypes() == null ? 0 : this.policyTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Root)) {
            return false;
        }
        Root other = (Root)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.policyTypes() == null ^ this.policyTypes() == null) {
            return false;
        }
        return other.policyTypes() == null || other.policyTypes().equals(this.policyTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.policyTypes() != null) {
            sb.append("PolicyTypes: ").append(this.policyTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RootMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private List<PolicyTypeSummary> policyTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(Root model) {
            this.setId(model.id);
            this.setArn(model.arn);
            this.setName(model.name);
            this.setPolicyTypes(model.policyTypes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<PolicyTypeSummary> getPolicyTypes() {
            return this.policyTypes;
        }

        @Override
        public final Builder policyTypes(Collection<PolicyTypeSummary> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(PolicyTypeSummary ... policyTypes) {
            this.policyTypes(Arrays.asList(policyTypes));
            return this;
        }

        public final void setPolicyTypes(Collection<PolicyTypeSummary> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
        }

        @SafeVarargs
        public final void setPolicyTypes(PolicyTypeSummary ... policyTypes) {
            this.policyTypes(Arrays.asList(policyTypes));
        }

        public Root build() {
            return new Root(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Root> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder policyTypes(Collection<PolicyTypeSummary> var1);

        public Builder policyTypes(PolicyTypeSummary ... var1);
    }
}

