/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.PolicyTargetSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTargetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTargetsForPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTargetsForPolicyResponse> {
    private final List<PolicyTargetSummary> targets;
    private final String nextToken;

    private ListTargetsForPolicyResponse(BuilderImpl builder) {
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    public List<PolicyTargetSummary> targets() {
        return this.targets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForPolicyResponse)) {
            return false;
        }
        ListTargetsForPolicyResponse other = (ListTargetsForPolicyResponse)((Object)obj);
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PolicyTargetSummary> targets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsForPolicyResponse model) {
            this.setTargets(model.targets);
            this.setNextToken(model.nextToken);
        }

        public final Collection<PolicyTargetSummary> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<PolicyTargetSummary> targets) {
            this.targets = PolicyTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(PolicyTargetSummary ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<PolicyTargetSummary> targets) {
            this.targets = PolicyTargetsCopier.copy(targets);
        }

        @SafeVarargs
        public final void setTargets(PolicyTargetSummary ... targets) {
            this.targets(Arrays.asList(targets));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTargetsForPolicyResponse build() {
            return new ListTargetsForPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTargetsForPolicyResponse> {
        public Builder targets(Collection<PolicyTargetSummary> var1);

        public Builder targets(PolicyTargetSummary ... var1);

        public Builder nextToken(String var1);
    }
}

