/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.ActionType;
import software.amazon.awssdk.services.organizations.transform.HandshakeFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HandshakeFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, HandshakeFilter> {
    private final String actionType;
    private final String parentHandshakeId;

    private HandshakeFilter(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.parentHandshakeId = builder.parentHandshakeId;
    }

    public String actionType() {
        return this.actionType;
    }

    public String parentHandshakeId() {
        return this.parentHandshakeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionType() == null ? 0 : this.actionType().hashCode());
        hashCode = 31 * hashCode + (this.parentHandshakeId() == null ? 0 : this.parentHandshakeId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeFilter)) {
            return false;
        }
        HandshakeFilter other = (HandshakeFilter)obj;
        if (other.actionType() == null ^ this.actionType() == null) {
            return false;
        }
        if (other.actionType() != null && !other.actionType().equals(this.actionType())) {
            return false;
        }
        if (other.parentHandshakeId() == null ^ this.parentHandshakeId() == null) {
            return false;
        }
        return other.parentHandshakeId() == null || other.parentHandshakeId().equals(this.parentHandshakeId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actionType() != null) {
            sb.append("ActionType: ").append(this.actionType()).append(",");
        }
        if (this.parentHandshakeId() != null) {
            sb.append("ParentHandshakeId: ").append(this.parentHandshakeId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String actionType;
        private String parentHandshakeId;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeFilter model) {
            this.setActionType(model.actionType);
            this.setParentHandshakeId(model.parentHandshakeId);
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final void setActionType(ActionType actionType) {
            this.actionType(actionType.toString());
        }

        public final String getParentHandshakeId() {
            return this.parentHandshakeId;
        }

        @Override
        public final Builder parentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
            return this;
        }

        public final void setParentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
        }

        public HandshakeFilter build() {
            return new HandshakeFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HandshakeFilter> {
        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder parentHandshakeId(String var1);
    }
}

