/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.PolicyTargetSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyTargetSummaryMarshaller {
    private static final MarshallingInfo<String> TARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetId").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final PolicyTargetSummaryMarshaller INSTANCE = new PolicyTargetSummaryMarshaller();

    private PolicyTargetSummaryMarshaller() {
    }

    public static PolicyTargetSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyTargetSummary policyTargetSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policyTargetSummary, (String)"policyTargetSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policyTargetSummary.targetId(), TARGETID_BINDING);
            protocolMarshaller.marshall((Object)policyTargetSummary.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)policyTargetSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)policyTargetSummary.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

