/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.organizations.model.Handshake;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HandshakeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<List> PARTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parties").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<Instant> REQUESTEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final HandshakeMarshaller INSTANCE = new HandshakeMarshaller();

    private HandshakeMarshaller() {
    }

    public static HandshakeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Handshake handshake, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)handshake, (String)"handshake");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)handshake.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)handshake.arn(), ARN_BINDING);
            protocolMarshaller.marshall(handshake.parties(), PARTIES_BINDING);
            protocolMarshaller.marshall((Object)handshake.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)handshake.requestedTimestamp(), REQUESTEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)handshake.expirationTimestamp(), EXPIRATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)handshake.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall(handshake.resources(), RESOURCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

