/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.organizations.model.AttachPolicyRequest;
import software.amazon.awssdk.services.organizations.transform.AttachPolicyRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttachPolicyRequestMarshaller
implements Marshaller<Request<AttachPolicyRequest>, AttachPolicyRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSOrganizationsV20161128.AttachPolicy").serviceName("Organizations").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public AttachPolicyRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AttachPolicyRequest> marshall(AttachPolicyRequest attachPolicyRequest) {
        Validate.paramNotNull((Object)((Object)attachPolicyRequest), (String)"attachPolicyRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)attachPolicyRequest);
            protocolMarshaller.startMarshalling();
            AttachPolicyRequestModelMarshaller.getInstance().marshall(attachPolicyRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

