/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.organizations.model.Account;

public class AccountUnmarshaller
implements Unmarshaller<Account, JsonUnmarshallerContext> {
    private static final AccountUnmarshaller INSTANCE = new AccountUnmarshaller();

    public Account unmarshall(JsonUnmarshallerContext context) throws Exception {
        Account.Builder accountBuilder = Account.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    accountBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    accountBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Email", targetDepth)) {
                    context.nextToken();
                    accountBuilder.email((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    accountBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    accountBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JoinedMethod", targetDepth)) {
                    context.nextToken();
                    accountBuilder.joinedMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JoinedTimestamp", targetDepth)) {
                    context.nextToken();
                    accountBuilder.joinedTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Account)accountBuilder.build();
    }

    public static AccountUnmarshaller getInstance() {
        return INSTANCE;
    }
}

