/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse;

public class ListTargetsForPolicyPublisher
implements SdkPublisher<ListTargetsForPolicyResponse> {
    private final OrganizationsAsyncClient client;
    private final ListTargetsForPolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTargetsForPolicyPublisher(OrganizationsAsyncClient client, ListTargetsForPolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTargetsForPolicyPublisher(OrganizationsAsyncClient client, ListTargetsForPolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTargetsForPolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTargetsForPolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListTargetsForPolicyPublisher resume(ListTargetsForPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTargetsForPolicyPublisher(this.client, (ListTargetsForPolicyRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTargetsForPolicyPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTargetsForPolicyResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTargetsForPolicyResponseFetcher
    implements AsyncPageFetcher<ListTargetsForPolicyResponse> {
        private ListTargetsForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsForPolicyResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListTargetsForPolicyResponse> nextPage(ListTargetsForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsForPolicyPublisher.this.client.listTargetsForPolicy(ListTargetsForPolicyPublisher.this.firstRequest);
            }
            return ListTargetsForPolicyPublisher.this.client.listTargetsForPolicy((ListTargetsForPolicyRequest)((Object)ListTargetsForPolicyPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

