/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;

public class ListRootsIterable
implements SdkIterable<ListRootsResponse> {
    private final OrganizationsClient client;
    private final ListRootsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRootsIterable(OrganizationsClient client, ListRootsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRootsResponseFetcher();
    }

    public Iterator<ListRootsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListRootsIterable resume(ListRootsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRootsIterable(this.client, (ListRootsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListRootsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListRootsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListRootsResponseFetcher
    implements SyncPageFetcher<ListRootsResponse> {
        private ListRootsResponseFetcher() {
        }

        public boolean hasNextPage(ListRootsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListRootsResponse nextPage(ListRootsResponse previousPage) {
            if (previousPage == null) {
                return ListRootsIterable.this.client.listRoots(ListRootsIterable.this.firstRequest);
            }
            return ListRootsIterable.this.client.listRoots((ListRootsRequest)((Object)ListRootsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

