/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;

public class ListPoliciesForTargetPublisher
implements SdkPublisher<ListPoliciesForTargetResponse> {
    private final OrganizationsAsyncClient client;
    private final ListPoliciesForTargetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPoliciesForTargetPublisher(OrganizationsAsyncClient client, ListPoliciesForTargetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPoliciesForTargetPublisher(OrganizationsAsyncClient client, ListPoliciesForTargetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPoliciesForTargetResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPoliciesForTargetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListPoliciesForTargetPublisher resume(ListPoliciesForTargetResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPoliciesForTargetPublisher(this.client, (ListPoliciesForTargetRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPoliciesForTargetPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPoliciesForTargetResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPoliciesForTargetResponseFetcher
    implements AsyncPageFetcher<ListPoliciesForTargetResponse> {
        private ListPoliciesForTargetResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesForTargetResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListPoliciesForTargetResponse> nextPage(ListPoliciesForTargetResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesForTargetPublisher.this.client.listPoliciesForTarget(ListPoliciesForTargetPublisher.this.firstRequest);
            }
            return ListPoliciesForTargetPublisher.this.client.listPoliciesForTarget((ListPoliciesForTargetRequest)((Object)ListPoliciesForTargetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

