/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListChildrenRequest;
import software.amazon.awssdk.services.organizations.model.ListChildrenResponse;

public class ListChildrenPublisher
implements SdkPublisher<ListChildrenResponse> {
    private final OrganizationsAsyncClient client;
    private final ListChildrenRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChildrenPublisher(OrganizationsAsyncClient client, ListChildrenRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChildrenPublisher(OrganizationsAsyncClient client, ListChildrenRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChildrenResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChildrenResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListChildrenPublisher resume(ListChildrenResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListChildrenPublisher(this.client, (ListChildrenRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListChildrenPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListChildrenResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListChildrenResponseFetcher
    implements AsyncPageFetcher<ListChildrenResponse> {
        private ListChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListChildrenResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListChildrenResponse> nextPage(ListChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListChildrenPublisher.this.client.listChildren(ListChildrenPublisher.this.firstRequest);
            }
            return ListChildrenPublisher.this.client.listChildren((ListChildrenRequest)((Object)ListChildrenPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

