/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.services.organizations.model.Root;
import software.amazon.awssdk.services.organizations.model.RootsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRootsResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListRootsResponse> {
    private final List<Root> roots;
    private final String nextToken;

    private ListRootsResponse(BuilderImpl builder) {
        super(builder);
        this.roots = builder.roots;
        this.nextToken = builder.nextToken;
    }

    public List<Root> roots() {
        return this.roots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRootsResponse)) {
            return false;
        }
        ListRootsResponse other = (ListRootsResponse)((Object)obj);
        return Objects.equals(this.roots(), other.roots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRootsResponse").add("Roots", this.roots()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Roots": {
                return Optional.of(clazz.cast(this.roots()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<Root> roots;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRootsResponse model) {
            super(model);
            this.roots(model.roots);
            this.nextToken(model.nextToken);
        }

        public final Collection<Root.Builder> getRoots() {
            return this.roots != null ? (Collection)this.roots.stream().map(Root::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roots(Collection<Root> roots) {
            this.roots = RootsCopier.copy(roots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roots(Root ... roots) {
            this.roots(Arrays.asList(roots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roots(Consumer<Root.Builder> ... roots) {
            this.roots(Stream.of(roots).map(c -> (Root)((Root.Builder)Root.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoots(Collection<Root.BuilderImpl> roots) {
            this.roots = RootsCopier.copyFromBuilder(roots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRootsResponse build() {
            return new ListRootsResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListRootsResponse> {
        public Builder roots(Collection<Root> var1);

        public Builder roots(Root ... var1);

        public Builder roots(Consumer<Root.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

