/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.HandshakeResourceType;
import software.amazon.awssdk.services.organizations.model.HandshakeResourcesCopier;
import software.amazon.awssdk.services.organizations.transform.HandshakeResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HandshakeResource
implements StructuredPojo,
ToCopyableBuilder<Builder, HandshakeResource> {
    private final String value;
    private final String type;
    private final List<HandshakeResource> resources;

    private HandshakeResource(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.resources = builder.resources;
    }

    public String value() {
        return this.value;
    }

    public HandshakeResourceType type() {
        return HandshakeResourceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<HandshakeResource> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeResource)) {
            return false;
        }
        HandshakeResource other = (HandshakeResource)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resources(), other.resources());
    }

    public String toString() {
        return ToString.builder((String)"HandshakeResource").add("Value", (Object)this.value()).add("Type", (Object)this.typeAsString()).add("Resources", this.resources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "Resources": {
                return Optional.of(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private String type;
        private List<HandshakeResource> resources;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeResource model) {
            this.value(model.value);
            this.type(model.type);
            this.resources(model.resources);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HandshakeResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Builder> getResources() {
            return this.resources != null ? (Collection)this.resources.stream().map(HandshakeResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(HandshakeResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (HandshakeResource)((Builder)HandshakeResource.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<BuilderImpl> resources) {
            this.resources = HandshakeResourcesCopier.copyFromBuilder(resources);
        }

        public HandshakeResource build() {
            return new HandshakeResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HandshakeResource> {
        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(HandshakeResourceType var1);

        public Builder resources(Collection<HandshakeResource> var1);

        public Builder resources(HandshakeResource ... var1);

        public Builder resources(Consumer<Builder> ... var1);
    }
}

