/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.services.organizations.model.PolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnablePolicyTypeRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, EnablePolicyTypeRequest> {
    private final String rootId;
    private final String policyType;

    private EnablePolicyTypeRequest(BuilderImpl builder) {
        super(builder);
        this.rootId = builder.rootId;
        this.policyType = builder.policyType;
    }

    public String rootId() {
        return this.rootId;
    }

    public PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public String policyTypeAsString() {
        return this.policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rootId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnablePolicyTypeRequest)) {
            return false;
        }
        EnablePolicyTypeRequest other = (EnablePolicyTypeRequest)((Object)obj);
        return Objects.equals(this.rootId(), other.rootId()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"EnablePolicyTypeRequest").add("RootId", (Object)this.rootId()).add("PolicyType", (Object)this.policyTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RootId": {
                return Optional.of(clazz.cast(this.rootId()));
            }
            case "PolicyType": {
                return Optional.of(clazz.cast(this.policyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String rootId;
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(EnablePolicyTypeRequest model) {
            super(model);
            this.rootId(model.rootId);
            this.policyType(model.policyType);
        }

        public final String getRootId() {
            return this.rootId;
        }

        @Override
        public final Builder rootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public final void setRootId(String rootId) {
            this.rootId = rootId;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EnablePolicyTypeRequest build() {
            return new EnablePolicyTypeRequest(this);
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    CopyableBuilder<Builder, EnablePolicyTypeRequest> {
        public Builder rootId(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

