/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason;
import software.amazon.awssdk.services.organizations.model.CreateAccountState;
import software.amazon.awssdk.services.organizations.transform.CreateAccountStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAccountStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, CreateAccountStatus> {
    private final String id;
    private final String accountName;
    private final String state;
    private final Instant requestedTimestamp;
    private final Instant completedTimestamp;
    private final String accountId;
    private final String failureReason;

    private CreateAccountStatus(BuilderImpl builder) {
        this.id = builder.id;
        this.accountName = builder.accountName;
        this.state = builder.state;
        this.requestedTimestamp = builder.requestedTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.accountId = builder.accountId;
        this.failureReason = builder.failureReason;
    }

    public String id() {
        return this.id;
    }

    public String accountName() {
        return this.accountName;
    }

    public CreateAccountState state() {
        return CreateAccountState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant requestedTimestamp() {
        return this.requestedTimestamp;
    }

    public Instant completedTimestamp() {
        return this.completedTimestamp;
    }

    public String accountId() {
        return this.accountId;
    }

    public CreateAccountFailureReason failureReason() {
        return CreateAccountFailureReason.fromValue(this.failureReason);
    }

    public String failureReasonAsString() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountStatus)) {
            return false;
        }
        CreateAccountStatus other = (CreateAccountStatus)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.requestedTimestamp(), other.requestedTimestamp()) && Objects.equals(this.completedTimestamp(), other.completedTimestamp()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateAccountStatus").add("Id", (Object)this.id()).add("AccountName", (Object)this.accountName()).add("State", (Object)this.stateAsString()).add("RequestedTimestamp", (Object)this.requestedTimestamp()).add("CompletedTimestamp", (Object)this.completedTimestamp()).add("AccountId", (Object)this.accountId()).add("FailureReason", (Object)this.failureReasonAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "AccountName": {
                return Optional.of(clazz.cast(this.accountName()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "RequestedTimestamp": {
                return Optional.of(clazz.cast(this.requestedTimestamp()));
            }
            case "CompletedTimestamp": {
                return Optional.of(clazz.cast(this.completedTimestamp()));
            }
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "FailureReason": {
                return Optional.of(clazz.cast(this.failureReasonAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateAccountStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String accountName;
        private String state;
        private Instant requestedTimestamp;
        private Instant completedTimestamp;
        private String accountId;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountStatus model) {
            this.id(model.id);
            this.accountName(model.accountName);
            this.state(model.state);
            this.requestedTimestamp(model.requestedTimestamp);
            this.completedTimestamp(model.completedTimestamp);
            this.accountId(model.accountId);
            this.failureReason(model.failureReason);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CreateAccountState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getRequestedTimestamp() {
            return this.requestedTimestamp;
        }

        @Override
        public final Builder requestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
            return this;
        }

        public final void setRequestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
        }

        public final Instant getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(CreateAccountFailureReason failureReason) {
            this.failureReason(failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public CreateAccountStatus build() {
            return new CreateAccountStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAccountStatus> {
        public Builder id(String var1);

        public Builder accountName(String var1);

        public Builder state(String var1);

        public Builder state(CreateAccountState var1);

        public Builder requestedTimestamp(Instant var1);

        public Builder completedTimestamp(Instant var1);

        public Builder accountId(String var1);

        public Builder failureReason(String var1);

        public Builder failureReason(CreateAccountFailureReason var1);
    }
}

