/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.PoliciesCopier;
import software.amazon.awssdk.services.organizations.model.PolicySummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPoliciesForTargetResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPoliciesForTargetResponse> {
    private final List<PolicySummary> policies;
    private final String nextToken;

    private ListPoliciesForTargetResponse(BuilderImpl builder) {
        this.policies = builder.policies;
        this.nextToken = builder.nextToken;
    }

    public List<PolicySummary> policies() {
        return this.policies;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policies() == null ? 0 : this.policies().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesForTargetResponse)) {
            return false;
        }
        ListPoliciesForTargetResponse other = (ListPoliciesForTargetResponse)((Object)obj);
        if (other.policies() == null ^ this.policies() == null) {
            return false;
        }
        if (other.policies() != null && !other.policies().equals(this.policies())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policies() != null) {
            sb.append("Policies: ").append(this.policies()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PolicySummary> policies;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesForTargetResponse model) {
            this.setPolicies(model.policies);
            this.setNextToken(model.nextToken);
        }

        public final Collection<PolicySummary> getPolicies() {
            return this.policies;
        }

        @Override
        public final Builder policies(Collection<PolicySummary> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicySummary ... policies) {
            if (this.policies == null) {
                this.policies = new ArrayList<PolicySummary>(policies.length);
            }
            for (PolicySummary e : policies) {
                this.policies.add(e);
            }
            return this;
        }

        public final void setPolicies(Collection<PolicySummary> policies) {
            this.policies = PoliciesCopier.copy(policies);
        }

        @SafeVarargs
        public final void setPolicies(PolicySummary ... policies) {
            if (this.policies == null) {
                this.policies = new ArrayList<PolicySummary>(policies.length);
            }
            for (PolicySummary e : policies) {
                this.policies.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPoliciesForTargetResponse build() {
            return new ListPoliciesForTargetResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPoliciesForTargetResponse> {
        public Builder policies(Collection<PolicySummary> var1);

        public Builder policies(PolicySummary ... var1);

        public Builder nextToken(String var1);
    }
}

