/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatus;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatusesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCreateAccountStatusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCreateAccountStatusResponse> {
    private final List<CreateAccountStatus> createAccountStatuses;
    private final String nextToken;

    private ListCreateAccountStatusResponse(BuilderImpl builder) {
        this.createAccountStatuses = builder.createAccountStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<CreateAccountStatus> createAccountStatuses() {
        return this.createAccountStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createAccountStatuses() == null ? 0 : this.createAccountStatuses().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreateAccountStatusResponse)) {
            return false;
        }
        ListCreateAccountStatusResponse other = (ListCreateAccountStatusResponse)((Object)obj);
        if (other.createAccountStatuses() == null ^ this.createAccountStatuses() == null) {
            return false;
        }
        if (other.createAccountStatuses() != null && !other.createAccountStatuses().equals(this.createAccountStatuses())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createAccountStatuses() != null) {
            sb.append("CreateAccountStatuses: ").append(this.createAccountStatuses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<CreateAccountStatus> createAccountStatuses;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreateAccountStatusResponse model) {
            this.setCreateAccountStatuses(model.createAccountStatuses);
            this.setNextToken(model.nextToken);
        }

        public final Collection<CreateAccountStatus> getCreateAccountStatuses() {
            return this.createAccountStatuses;
        }

        @Override
        public final Builder createAccountStatuses(Collection<CreateAccountStatus> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copy(createAccountStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createAccountStatuses(CreateAccountStatus ... createAccountStatuses) {
            if (this.createAccountStatuses == null) {
                this.createAccountStatuses = new ArrayList<CreateAccountStatus>(createAccountStatuses.length);
            }
            for (CreateAccountStatus e : createAccountStatuses) {
                this.createAccountStatuses.add(e);
            }
            return this;
        }

        public final void setCreateAccountStatuses(Collection<CreateAccountStatus> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copy(createAccountStatuses);
        }

        @SafeVarargs
        public final void setCreateAccountStatuses(CreateAccountStatus ... createAccountStatuses) {
            if (this.createAccountStatuses == null) {
                this.createAccountStatuses = new ArrayList<CreateAccountStatus>(createAccountStatuses.length);
            }
            for (CreateAccountStatus e : createAccountStatuses) {
                this.createAccountStatuses.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListCreateAccountStatusResponse build() {
            return new ListCreateAccountStatusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCreateAccountStatusResponse> {
        public Builder createAccountStatuses(Collection<CreateAccountStatus> var1);

        public Builder createAccountStatuses(CreateAccountStatus ... var1);

        public Builder nextToken(String var1);
    }
}

